<?xml version="1.0" encoding="UTF-8"?>
<grammar datatypeLibrary="http://www.w3.org/2001/XMLSchema-datatypes" xmlns="http://relaxng.org/ns/structure/1.0" xmlns:a="http://relaxng.org/ns/compatibility/annotations/1.0">
<!-- ITSIG exchange Table Module -->
<!-- file: stdex-table.mod -->
<!-- ITSIG exchange Table Module

     (c) International Organization for Standardization 1991 Permission
         to copy in any form is granted for use with comforming WebSGML 
         systems and appilications as defined in ISO 8879:1986(WWW),
         provided this notice is included in all copies.
-->
<!--
    Table is based on MIL-HDBK-28001:1995

    parameter entities to be defined 

    std.tab, std.tabtit 
    std.cals
    m.entry    - cell model

    CALS table is used
-->
<!-- Entry cell model -->
<!-- *** ENTITY % m.entry  "(%m.par;|p|tabnote)+"     -->
  <define name="m.entry">
    <zeroOrMore>
      <choice>
        <ref name="m.par"/>
        <ref name="element.p"/>
        <ref name="element.tabnote"/>
      </choice>
    </zeroOrMore>
  </define>
  <include href="calstab.rng"/>
<!-- ***** ELEMENT table       (tabtitle?, tgroup)  -(table|figure ) -->
  <define name="element.table">
    <element name="table">
      <ref name="attlist.table"/>
      <optional>
        <ref name="element.tabtitle"/>
      </optional>
      <ref name="element.tgroup"/>
    </element>
  </define>
  <define name="attlist.table" combine="interleave">
    <optional>
      <attribute name="colsep">
        <ref name="yesorno"/>
      </attribute>
    </optional>
    <optional>
      <attribute name="frame">
        <choice>
          <value>all</value>
          <value>top</value>
          <value>bottom</value>
          <value>topbot</value>
          <value>sides</value>
          <value>none</value>
        </choice>
      </attribute>
    </optional>
    <optional>
      <attribute name="pgwide">
        <ref name="yesorno"/>
      </attribute>
    </optional>
    <optional>
      <attribute name="rowsep">
        <ref name="yesorno"/>
      </attribute>
    </optional>
    <optional>
      <attribute name="tabstyle"/>
    </optional>
  </define>
<!-- ***** ELEMENT tabtitle   ((#PCDATA|hp|formula|artwork|fn|xref|extdoc|term|tol|superscript|subscript |ix |table|figure )*)   -(note|fn |ix |table|figure ) -->
  <define name="element.tabtitle">
    <element name="tabtitle">
      <ref name="attlist.tabtitle"/>
      <zeroOrMore>
        <choice>
          <text/>
          <ref name="inline"/>
          <ref name="base.include"/>
          <ref name="local.include"/>
          <ref name="base.float"/>
          <ref name="local.float"/>
        </choice>
      </zeroOrMore>
    </element>
  </define>
  <define name="attlist.tabtitle" combine="interleave">
    <optional>
      <attribute name="id">
        <ref name="ID"/>
      </attribute>
    </optional>
    <optional>
      <attribute name="gtext"/>
    </optional>
  </define>
<!-- ***** ELEMENT tabnote     (%m.par;)*  -(%informative|%include;|%float;) -->
  <define name="element.tabnote">
    <element name="tabnote">
      <ref name="attlist.tabnote"/>
      <zeroOrMore>
        <ref name="m.par"/>
      </zeroOrMore>
    </element>
  </define>
  <define name="attlist.tabnote" combine="interleave">
    <optional>
      <attribute name="id">
        <ref name="ID"/>
      </attribute>
    </optional>
    <optional>
      <attribute name="gtext"/>
    </optional>
  </define>
</grammar>
