<?xml version="1.0" encoding="UTF-8"?>
<grammar datatypeLibrary="http://www.w3.org/2001/XMLSchema-datatypes" xmlns="http://relaxng.org/ns/structure/1.0" xmlns:a="http://relaxng.org/ns/compatibility/annotations/1.0">
<!-- ITSIG Math Module -->
<!-- file: stdex-math.mod -->
<!-- ITSIG Math Module

     (c) International Organization for Standardization 1991 Permission
         to copy in any form is granted for use with comforming WebSGML 
         systems and appilications as defined in ISO 8879:1986(WWW),
         provided this notice is included in all copies.
-->
<!-- This is the ISO12083:1994 document type definition for Mathematics    -->
<!-- Copyright: (C) International Organization for Standardization 1994.
Permission to copy in any form is granted for use with conforming SGML
systems and applications as defined in ISO 8879:1986, provided this notice
is included in all copies.                                                 -->
<!-- Math Extension Module -->
  <include href="stdex-math-extension.mod"/>
<!-- ===================================================================== -->
<!--            PUBLIC DOCUMENT TYPE DEFINITION SUBSET                     -->
<!-- ===================================================================== -->
<!--
This DTD is included by the Book and Article DTDs of ISO12083:1994.
As it is a separate entity it may also be included by other DTDs.

Since there is no consensus on how to describe the semantics of formulas,
it only describes their presentational or visual structure. Since, however,
there is a strong need for such description (especially within the
print-disabled community), it is recommended that the following
declaration be added where there is a requirement for a consistent,
standardized mechanism to carry semantic meanings for the SGML
elements declared throughout this part of this International Standard:

<!ENTITY % SDAMAP       "SDAMAP   NAME    #IMPLIED"           >

and that the attribute represented by %SDAMAP; be made available for
all elements which may require a semantic association, or, in the simpler
case, be added to all elements in this DTD.                     -->
<!-- ===================================================================== -->
<!--  Parameter entities describing the possible contents of formulas.     -->
<!-- ===================================================================== -->
<!-- character transformations -->
  <define name="p.trans">
    <choice>
      <ref name="element.bold"/>
      <ref name="element.italic"/>
      <ref name="element.sansser"/>
      <ref name="element.typewrit"/>
      <ref name="element.smallcap"/>
      <ref name="element.roman"/>
    </choice>
  </define>
<!-- mathematical formula elements -->
  <define name="m.math">
    <choice>
      <text/>
      <ref name="element.fraction"/>
      <ref name="element.subform"/>
      <ref name="element.sup"/>
      <ref name="element.inf"/>
      <ref name="element.top"/>
      <ref name="element.bottom"/>
      <ref name="element.middle"/>
      <ref name="element.fence"/>
      <ref name="element.mark"/>
      <ref name="element.post"/>
      <ref name="element.box"/>
      <ref name="element.overline"/>
      <ref name="element.undrline"/>
      <ref name="element.radical"/>
      <ref name="element.array"/>
      <ref name="element.hspace"/>
      <ref name="element.vspace"/>
      <ref name="element.break"/>
      <ref name="element.markref"/>
    </choice>
  </define>
<!-- ===================================================================== -->
<!-- Accessible Document and other Parameter Entities        
     If this DTD is not imbedded by a ISO12083:1994 Book or Article,
     the comment delimiters should be removed.                             -->
<!-- ===================================================================== -->
<!--ENTITY % SDAFORM      "SDAFORM   CDATA    #FIXED"                      -->
<!--ENTITY % SDARULE      "SDARULE   CDATA    #FIXED"                      -->
<!--ENTITY % SDAPREF      "SDAPREF   CDATA    #FIXED"                      -->
<!--ENTITY % SDASUFF      "SDASUFF   CDATA    #FIXED"                      -->
<!--ENTITY % SDASUSP      "SDASUSP   NAME     #FIXED"                      -->
<!-- ===================================================================== -->
<!-- This entity is for an attribute to indicate which alphabet is 
     used in the element (formula, dformula). You may change this to 
     a notation attribute, where the notation could describe a 
     keyboard mapping. Please modify the set as necessary.                 
     If this DTD is not imbedded by a ISO12083:1994 Book or Article,
     the comment delimiters should be removed.                             -->
<!-- ===================================================================== -->
<!-- ===================================================================== -->
<!-- character transformations                                             -->
<!-- ===================================================================== -->
<!--      ELEMENT              CONTENT            -->
<!-- bold -->
  <define name="element.bold">
    <element name="bold">
      <ref name="attlist.bold"/>
      <zeroOrMore>
        <choice>
          <text/>
          <ref name="p.trans"/>
        </choice>
      </zeroOrMore>
    </element>
  </define>
  <define name="attlist.bold" combine="interleave">
    <empty/>
  </define>
<!-- italic -->
  <define name="element.italic">
    <element name="italic">
      <ref name="attlist.italic"/>
      <zeroOrMore>
        <choice>
          <text/>
          <ref name="p.trans"/>
        </choice>
      </zeroOrMore>
    </element>
  </define>
  <define name="attlist.italic" combine="interleave">
    <empty/>
  </define>
<!-- sans serif -->
  <define name="element.sansser">
    <element name="sansser">
      <ref name="attlist.sansser"/>
      <zeroOrMore>
        <choice>
          <text/>
          <ref name="p.trans"/>
        </choice>
      </zeroOrMore>
    </element>
  </define>
  <define name="attlist.sansser" combine="interleave">
    <empty/>
  </define>
<!-- typewriter -->
  <define name="element.typewrit">
    <element name="typewrit">
      <ref name="attlist.typewrit"/>
      <zeroOrMore>
        <choice>
          <text/>
          <ref name="p.trans"/>
        </choice>
      </zeroOrMore>
    </element>
  </define>
  <define name="attlist.typewrit" combine="interleave">
    <empty/>
  </define>
<!-- small caps -->
  <define name="element.smallcap">
    <element name="smallcap">
      <ref name="attlist.smallcap"/>
      <zeroOrMore>
        <choice>
          <text/>
          <ref name="p.trans"/>
        </choice>
      </zeroOrMore>
    </element>
  </define>
  <define name="attlist.smallcap" combine="interleave">
    <empty/>
  </define>
<!-- roman -->
  <define name="element.roman">
    <element name="roman">
      <ref name="attlist.roman"/>
      <zeroOrMore>
        <choice>
          <text/>
          <ref name="p.trans"/>
        </choice>
      </zeroOrMore>
    </element>
  </define>
  <define name="attlist.roman" combine="interleave">
    <empty/>
  </define>
<!-- ===================================================================== -->
<!-- Fractions                                                             -->
<!-- ===================================================================== -->
<!--      ELEMENT              CONTENT            -->
<!-- fraction -->
  <define name="element.fraction">
    <element name="fraction">
      <ref name="attlist.fraction"/>
      <ref name="element.num"/>
      <ref name="element.den"/>
    </element>
  </define>
<!-- numerator -->
  <define name="element.num">
    <element name="num">
      <ref name="attlist.num"/>
      <zeroOrMore>
        <choice>
          <ref name="m.math"/>
          <ref name="p.trans"/>
        </choice>
      </zeroOrMore>
    </element>
  </define>
  <define name="attlist.num" combine="interleave">
    <empty/>
  </define>
<!-- denominator -->
  <define name="element.den">
    <element name="den">
      <ref name="attlist.den"/>
      <zeroOrMore>
        <choice>
          <ref name="m.math"/>
          <ref name="p.trans"/>
        </choice>
      </zeroOrMore>
    </element>
  </define>
  <define name="attlist.den" combine="interleave">
    <empty/>
  </define>
<!--      ELEMENT   NAME       VALUE            DEFAULT                    -->
  <define name="attlist.fraction" combine="interleave">
    <optional>
      <attribute name="shape">
        <choice>
          <value>built</value>
          <value>case</value>
        </choice>
      </attribute>
    </optional>
    <optional>
      <attribute name="align" a:defaultValue="center">
        <choice>
          <value>left</value>
          <value>center</value>
          <value>right</value>
        </choice>
      </attribute>
    </optional>
    <optional>
      <attribute name="style" a:defaultValue="single">
        <choice>
          <value>single</value>
          <value>double</value>
          <value>triple</value>
          <value>dash</value>
          <value>dot</value>
          <value>bold</value>
          <value>blank</value>
          <value>none</value>
        </choice>
      </attribute>
    </optional>
  </define>
<!-- ===================================================================== -->
<!-- Superiors, inferiors, accents, over and under                         -->
<!-- ===================================================================== -->
<!--      ELEMENT              CONTENT             -->
<!-- superior -->
  <define name="element.sup">
    <element name="sup">
      <ref name="attlist.sup"/>
      <zeroOrMore>
        <choice>
          <ref name="m.math"/>
          <ref name="p.trans"/>
        </choice>
      </zeroOrMore>
    </element>
  </define>
<!-- inferior -->
  <define name="element.inf">
    <element name="inf">
      <ref name="attlist.inf"/>
      <zeroOrMore>
        <choice>
          <ref name="m.math"/>
          <ref name="p.trans"/>
        </choice>
      </zeroOrMore>
    </element>
  </define>
<!--      ELEMENT   NAME       VALUE            DEFAULT                    -->
  <define name="attlist.sup" combine="interleave">
    <optional>
      <attribute name="location" a:defaultValue="post">
        <choice>
          <value>pre</value>
          <value>post</value>
        </choice>
      </attribute>
    </optional>
    <optional>
      <attribute name="arrange" a:defaultValue="compact">
        <choice>
          <value>compact</value>
          <value>stagger</value>
        </choice>
      </attribute>
    </optional>
  </define>
  <define name="attlist.inf" combine="interleave">
    <optional>
      <attribute name="location" a:defaultValue="post">
        <choice>
          <value>pre</value>
          <value>post</value>
        </choice>
      </attribute>
    </optional>
    <optional>
      <attribute name="arrange" a:defaultValue="compact">
        <choice>
          <value>compact</value>
          <value>stagger</value>
        </choice>
      </attribute>
    </optional>
  </define>
<!-- ===================================================================== -->
<!-- Embellishments                                                        -->
<!-- ===================================================================== -->
<!--      ELEMENT              CONTENT             -->
<!-- top embellishment -->
  <define name="element.top">
    <element name="top">
      <ref name="attlist.top"/>
      <zeroOrMore>
        <choice>
          <ref name="m.math"/>
          <ref name="p.trans"/>
        </choice>
      </zeroOrMore>
    </element>
  </define>
<!-- middle, or "through" -->
  <define name="element.middle">
    <element name="middle">
      <ref name="attlist.middle"/>
      <zeroOrMore>
        <choice>
          <ref name="m.math"/>
          <ref name="p.trans"/>
        </choice>
      </zeroOrMore>
    </element>
  </define>
<!-- bottom embellishment -->
  <define name="element.bottom">
    <element name="bottom">
      <ref name="attlist.bottom"/>
      <zeroOrMore>
        <choice>
          <ref name="m.math"/>
          <ref name="p.trans"/>
        </choice>
      </zeroOrMore>
    </element>
  </define>
<!--      ELEMENT   NAME       VALUE            DEFAULT                    -->
<!-- to pass on the height -->
  <define name="attlist.top" combine="interleave">
    <optional>
      <attribute name="align" a:defaultValue="center">
        <choice>
          <value>left</value>
          <value>center</value>
          <value>right</value>
        </choice>
      </attribute>
    </optional>
    <optional>
      <attribute name="sizeid">
        <data type="ID"/>
      </attribute>
    </optional>
  </define>
<!-- to pass on the height -->
  <define name="attlist.middle" combine="interleave">
    <optional>
      <attribute name="align" a:defaultValue="center">
        <choice>
          <value>left</value>
          <value>center</value>
          <value>right</value>
        </choice>
      </attribute>
    </optional>
    <optional>
      <attribute name="sizeid">
        <data type="ID"/>
      </attribute>
    </optional>
  </define>
<!-- to pass on the height -->
  <define name="attlist.bottom" combine="interleave">
    <optional>
      <attribute name="align" a:defaultValue="center">
        <choice>
          <value>left</value>
          <value>center</value>
          <value>right</value>
        </choice>
      </attribute>
    </optional>
    <optional>
      <attribute name="sizeid">
        <data type="ID"/>
      </attribute>
    </optional>
  </define>
<!-- The subform element is defined later                                  -->
<!-- ===================================================================== -->
<!-- Fences, boxes, overlines and underlines                               -->
<!-- ===================================================================== -->
<!--      ELEMENT              CONTENT             -->
  <define name="element.mark">
    <element name="mark">
      <ref name="attlist.mark"/>
      <empty/>
    </element>
  </define>
<!-- fence -->
  <define name="element.fence">
    <element name="fence">
      <ref name="attlist.fence"/>
      <zeroOrMore>
        <choice>
          <ref name="m.math"/>
          <ref name="p.trans"/>
        </choice>
      </zeroOrMore>
    </element>
  </define>
<!-- post -->
  <define name="element.post">
    <element name="post">
      <ref name="attlist.post"/>
      <empty/>
    </element>
  </define>
<!-- box -->
  <define name="element.box">
    <element name="box">
      <ref name="attlist.box"/>
      <zeroOrMore>
        <choice>
          <ref name="m.math"/>
          <ref name="p.trans"/>
        </choice>
      </zeroOrMore>
    </element>
  </define>
<!-- overline -->
  <define name="element.overline">
    <element name="overline">
      <ref name="attlist.overline"/>
      <zeroOrMore>
        <choice>
          <ref name="m.math"/>
          <ref name="p.trans"/>
        </choice>
      </zeroOrMore>
    </element>
  </define>
<!-- underline -->
  <define name="element.undrline">
    <element name="undrline">
      <ref name="attlist.undrline"/>
      <zeroOrMore>
        <choice>
          <ref name="m.math"/>
          <ref name="p.trans"/>
        </choice>
      </zeroOrMore>
    </element>
  </define>
<!--      ELEMENT   NAME       VALUE            DEFAULT                    -->
  <define name="attlist.mark" combine="interleave">
    <attribute name="id">
      <data type="ID"/>
    </attribute>
  </define>
<!-- lpost : left post -->
<!-- rpost : right post -->
<!-- sizeid : to pass on the height -->
<!-- sizeref : to pick up a height -->
  <define name="attlist.fence" combine="interleave">
    <optional>
      <attribute name="lpost" a:defaultValue="|"/>
    </optional>
    <optional>
      <attribute name="rpost" a:defaultValue="|"/>
    </optional>
    <optional>
      <attribute name="style" a:defaultValue="single">
        <choice>
          <value>single</value>
          <value>double</value>
          <value>triple</value>
          <value>dash</value>
          <value>dot</value>
          <value>bold</value>
          <value>blank</value>
          <value>none</value>
        </choice>
      </attribute>
    </optional>
    <optional>
      <attribute name="sizeid">
        <data type="ID"/>
      </attribute>
    </optional>
    <optional>
      <attribute name="sizeref">
        <data type="IDREF"/>
      </attribute>
    </optional>
  </define>
<!-- sizeid : to pass on the height -->
<!-- sizeref : to pick up a height -->
  <define name="attlist.post" combine="interleave">
    <optional>
      <attribute name="post" a:defaultValue="|"/>
    </optional>
    <optional>
      <attribute name="style" a:defaultValue="single">
        <choice>
          <value>single</value>
          <value>double</value>
          <value>triple</value>
          <value>dash</value>
          <value>dot</value>
          <value>bold</value>
          <value>blank</value>
          <value>none</value>
        </choice>
      </attribute>
    </optional>
    <optional>
      <attribute name="sizeid">
        <data type="ID"/>
      </attribute>
    </optional>
    <optional>
      <attribute name="sizeref">
        <data type="IDREF"/>
      </attribute>
    </optional>
  </define>
  <define name="attlist.box" combine="interleave">
    <optional>
      <attribute name="style" a:defaultValue="single">
        <choice>
          <value>single</value>
          <value>double</value>
          <value>triple</value>
          <value>dash</value>
          <value>dot</value>
          <value>bold</value>
          <value>blank</value>
          <value>none</value>
        </choice>
      </attribute>
    </optional>
  </define>
<!-- type : embellishment type -->
  <define name="attlist.overline" combine="interleave">
    <optional>
      <attribute name="type" a:defaultValue="-"/>
    </optional>
    <optional>
      <attribute name="style" a:defaultValue="single">
        <choice>
          <value>single</value>
          <value>double</value>
          <value>triple</value>
          <value>dash</value>
          <value>dot</value>
          <value>bold</value>
          <value>blank</value>
          <value>none</value>
        </choice>
      </attribute>
    </optional>
    <optional>
      <attribute name="start">
        <data type="IDREF"/>
      </attribute>
    </optional>
    <optional>
      <attribute name="end">
        <data type="IDREF"/>
      </attribute>
    </optional>
  </define>
<!-- embellishment type -->
  <define name="attlist.undrline" combine="interleave">
    <optional>
      <attribute name="type" a:defaultValue="_"/>
    </optional>
    <optional>
      <attribute name="style" a:defaultValue="single">
        <choice>
          <value>single</value>
          <value>double</value>
          <value>triple</value>
          <value>dash</value>
          <value>dot</value>
          <value>bold</value>
          <value>blank</value>
          <value>none</value>
        </choice>
      </attribute>
    </optional>
    <optional>
      <attribute name="start">
        <data type="IDREF"/>
      </attribute>
    </optional>
    <optional>
      <attribute name="end">
        <data type="IDREF"/>
      </attribute>
    </optional>
  </define>
<!-- ===================================================================== -->
<!-- Labelled arrows                                                       -->
<!-- ===================================================================== -->
<!--      ELEMENT              CONTENT             -->
<!-- base element  -->
  <define name="element.subform">
    <element name="subform">
      <ref name="attlist.subform"/>
      <zeroOrMore>
        <choice>
          <ref name="m.math"/>
          <ref name="p.trans"/>
        </choice>
      </zeroOrMore>
    </element>
  </define>
<!--      ELEMENT   NAME       VALUE            DEFAULT                    -->
<!-- sizeid : to pass on a width, or a height -->
<!-- sizeref : to pick up a width -->
  <define name="attlist.subform" combine="interleave">
    <optional>
      <attribute name="sizeid">
        <data type="ID"/>
      </attribute>
    </optional>
    <optional>
      <attribute name="sizeref">
        <data type="IDREF"/>
      </attribute>
    </optional>
  </define>
<!-- ===================================================================== -->
<!-- Roots                                                                 -->
<!-- ===================================================================== -->
<!--      ELEMENT              CONTENT             -->
<!-- root or radical -->
  <define name="element.radical">
    <element name="radical">
      <ref name="attlist.radical"/>
      <optional>
        <ref name="element.radix"/>
      </optional>
      <ref name="element.radicand"/>
    </element>
  </define>
  <define name="attlist.radical" combine="interleave">
    <empty/>
  </define>
<!-- radix -->
  <define name="element.radix">
    <element name="radix">
      <ref name="attlist.radix"/>
      <zeroOrMore>
        <choice>
          <ref name="m.math"/>
          <ref name="p.trans"/>
        </choice>
      </zeroOrMore>
    </element>
  </define>
  <define name="attlist.radix" combine="interleave">
    <empty/>
  </define>
<!-- radicand -->
  <define name="element.radicand">
    <element name="radicand">
      <ref name="attlist.radicand"/>
      <zeroOrMore>
        <choice>
          <ref name="m.math"/>
          <ref name="p.trans"/>
        </choice>
      </zeroOrMore>
    </element>
  </define>
  <define name="attlist.radicand" combine="interleave">
    <empty/>
  </define>
<!-- ===================================================================== -->
<!-- Arrays                                                                -->
<!-- ===================================================================== -->
<!--      ELEMENT              CONTENT             -->
<!-- array -->
  <define name="element.array">
    <element name="array">
      <ref name="attlist.array"/>
      <choice>
        <oneOrMore>
          <ref name="element.arrayrow"/>
        </oneOrMore>
        <oneOrMore>
          <ref name="element.arraycol"/>
        </oneOrMore>
      </choice>
    </element>
  </define>
<!-- array row -->
  <define name="element.arrayrow">
    <element name="arrayrow">
      <ref name="attlist.arrayrow"/>
      <oneOrMore>
        <ref name="element.arraycel"/>
      </oneOrMore>
    </element>
  </define>
  <define name="attlist.arrayrow" combine="interleave">
    <empty/>
  </define>
<!-- array column -->
  <define name="element.arraycol">
    <element name="arraycol">
      <ref name="attlist.arraycol"/>
      <oneOrMore>
        <ref name="element.arraycel"/>
      </oneOrMore>
    </element>
  </define>
  <define name="attlist.arraycol" combine="interleave">
    <empty/>
  </define>
<!-- array cell -->
  <define name="element.arraycel">
    <element name="arraycel">
      <ref name="attlist.arraycel"/>
      <zeroOrMore>
        <choice>
          <ref name="m.math"/>
          <ref name="p.trans"/>
        </choice>
      </zeroOrMore>
    </element>
  </define>
  <define name="attlist.arraycel" combine="interleave">
    <empty/>
  </define>
<!--      ELEMENT   NAME       VALUE            DEFAULT                    -->
<!-- rowalign : row alignment -->
<!-- colalign : column alignment -->
<!-- rowsep : row separators -->
<!-- colsep : column separators -->
  <define name="attlist.array" combine="interleave">
    <optional>
      <attribute name="rowalign">
        <data type="NMTOKENS"/>
      </attribute>
    </optional>
    <optional>
      <attribute name="colalign">
        <data type="NMTOKENS"/>
      </attribute>
    </optional>
    <optional>
      <attribute name="rowsep">
        <data type="NMTOKENS"/>
      </attribute>
    </optional>
    <optional>
      <attribute name="colsep">
        <data type="NMTOKENS"/>
      </attribute>
    </optional>
  </define>
<!-- ===================================================================== -->
<!-- Spacing                                                               -->
<!-- ===================================================================== -->
<!--      ELEMENT              CONTENT        -->
<!-- horizontal spacing -->
  <define name="element.hspace">
    <element name="hspace">
      <ref name="attlist.hspace"/>
      <empty/>
    </element>
  </define>
<!-- vertical spacing -->
  <define name="element.vspace">
    <element name="vspace">
      <ref name="attlist.vspace"/>
      <empty/>
    </element>
  </define>
<!-- turn line, break -->
  <define name="element.break">
    <element name="break">
      <ref name="attlist.break"/>
      <empty/>
    </element>
  </define>
  <define name="attlist.break" combine="interleave">
    <empty/>
  </define>
<!-- hmark reference -->
  <define name="element.markref">
    <element name="markref">
      <ref name="attlist.markref"/>
      <empty/>
    </element>
  </define>
<!--      ELEMENT   NAME       VALUE            DEFAULT                    -->
<!-- units as required -->
  <define name="attlist.hspace" combine="interleave">
    <optional>
      <attribute name="space" a:defaultValue="2 dd"/>
    </optional>
  </define>
<!-- units as required -->
  <define name="attlist.vspace" combine="interleave">
    <optional>
      <attribute name="space" a:defaultValue="2 dd"/>
    </optional>
  </define>
<!-- direct : horizontal or vertical -->
  <define name="attlist.markref" combine="interleave">
    <attribute name="refid">
      <data type="IDREF"/>
    </attribute>
    <optional>
      <attribute name="direct" a:defaultValue="hor">
        <choice>
          <value>hor</value>
          <value>ver</value>
        </choice>
      </attribute>
    </optional>
  </define>
<!-- ===================================================================== -->
<!-- the formula elements                                                  -->
<!-- ===================================================================== -->
<!--      ELEMENT              CONTENT                          -->
<!-- in-line formula -->
  <define name="element.formula">
    <element name="formula">
      <ref name="attlist.formula"/>
      <zeroOrMore>
        <choice>
          <ref name="m.math"/>
          <ref name="p.trans"/>
          <ref name="std.mart"/>
        </choice>
      </zeroOrMore>
    </element>
  </define>
<!-- display formula -->
  <define name="element.dformula">
    <element name="dformula">
      <ref name="attlist.dformula"/>
      <zeroOrMore>
        <choice>
          <ref name="m.math"/>
          <ref name="p.trans"/>
          <ref name="std.mart"/>
        </choice>
      </zeroOrMore>
    </element>
  </define>
<!--      ELEMENT   NAME       VALUE            DEFAULT                    -->
  <define name="attlist.formula" combine="interleave">
    <optional>
      <attribute name="id">
        <data type="ID"/>
      </attribute>
    </optional>
    <optional>
      <attribute name="mathnota" a:defaultValue="I12083">
        <choice>
          <value>TR9573</value>
          <value>I12083</value>
          <value>LATEX</value>
        </choice>
      </attribute>
    </optional>
    <optional>
      <attribute name="mode" a:defaultValue="INLINE">
        <value>INLINE</value>
      </attribute>
    </optional>
    <optional>
      <attribute name="alphabet" a:defaultValue="latin">
        <choice>
          <value>latin</value>
          <value>greek</value>
          <value>cyrillic</value>
          <value>hebrew</value>
          <value>kanji</value>
        </choice>
      </attribute>
    </optional>
  </define>
  <define name="attlist.dformula" combine="interleave">
    <optional>
      <attribute name="id">
        <data type="ID"/>
      </attribute>
    </optional>
    <optional>
      <attribute name="num" a:defaultValue="nonum">
        <choice>
          <value>num</value>
          <value>nonum</value>
        </choice>
      </attribute>
    </optional>
    <optional>
      <attribute name="align" a:defaultValue="center">
        <choice>
          <value>left</value>
          <value>center</value>
          <value>right</value>
        </choice>
      </attribute>
    </optional>
    <optional>
      <attribute name="gtext"/>
    </optional>
    <optional>
      <attribute name="mathnota" a:defaultValue="I12083">
        <choice>
          <value>TR9573</value>
          <value>I12083</value>
          <value>LATEX</value>
        </choice>
      </attribute>
    </optional>
    <optional>
      <attribute name="mode" a:defaultValue="DISPLAY">
        <value>DISPLAY</value>
      </attribute>
    </optional>
    <optional>
      <attribute name="alphabet" a:defaultValue="latin">
        <choice>
          <value>latin</value>
          <value>greek</value>
          <value>cyrillic</value>
          <value>hebrew</value>
          <value>kanji</value>
        </choice>
      </attribute>
    </optional>
  </define>
</grammar>
