<?xml version="1.0" encoding="UTF-8"?>
<grammar datatypeLibrary="http://www.w3.org/2001/XMLSchema-datatypes" xmlns="http://relaxng.org/ns/structure/1.0" xmlns:a="http://relaxng.org/ns/compatibility/annotations/1.0">
<!-- ITSIG exchange Entity Module -->
<!-- file: stdex-ent.mod -->
<!-- ITSIG exchange Entity Module

     This is new DTD for ISO standards. Version 0.94 
     -//ISO/CS//DTD std::base::0.94//EN

     (c) International Organization for Standardization 1991 Permission
         to copy in any form is granted for use with comforming WebSGML 
         systems and appilications as defined in ISO 8879:1986(WWW),
         provided this notice is included in all copies.
-->
<!-- 
    parameter entities to be defined for local additions

    local.display  - local display element types 
    local.inline   - local inline element types
    local.float    - local float element types 
    local.include  - local includable element types

    local.topinclude - local top level inclusions
    local.topexclude - the same as previous, but exclusions

    local.normative    - local normative element types
    local.informative  - local informative element types
  
-->
  <define name="local.display">
    <notAllowed/>
  </define>
  <define name="local.inline">
    <notAllowed/>
  </define>
  <define name="local.float">
    <notAllowed/>
  </define>
  <define name="local.include">
    <notAllowed/>
  </define>
<!-- 
    parameter entities to be defined for local variations

    base.xref - 
    base.page - 
-->
  <define name="base.xref">
    <attribute name="format"/>
  </define>
  <define name="base.page">
    <empty/>
  </define>
<!--
    Main Part
-->
  <define name="base.note">
    <ref name="element.note"/>
  </define>
  <define name="base.xmp">
    <ref name="element.xmp"/>
  </define>
  <define name="base.df">
    <ref name="element.dformula"/>
  </define>
  <define name="base.f">
    <ref name="element.formula"/>
  </define>
  <define name="base.list">
    <choice>
      <ref name="element.ol"/>
      <ref name="element.ul"/>
      <ref name="element.dl"/>
    </choice>
  </define>
<!-- entities below were SDATA -->
<!-- 
            Element type groups
-->
  <define name="base.inline">
    <choice>
      <ref name="element.hp"/>
      <ref name="base.f"/>
      <ref name="element.artwork"/>
      <ref name="element.fn"/>
      <ref name="element.xref"/>
      <ref name="element.extdoc"/>
      <ref name="element.term"/>
      <ref name="element.tol"/>
      <ref name="element.superscript"/>
      <ref name="element.subscript"/>
    </choice>
  </define>
  <define name="inline">
    <choice>
      <ref name="base.inline"/>
      <ref name="local.inline"/>
    </choice>
  </define>
  <define name="base.float">
    <choice>
      <ref name="element.table"/>
      <ref name="element.figure"/>
    </choice>
  </define>
  <define name="base.include">
    <ref name="element.ix"/>
  </define>
<!-- without PARAGRAPH  -->
  <define name="base.display">
    <choice>
      <ref name="base.list"/>
      <ref name="base.df"/>
      <ref name="base.xmp"/>
      <ref name="base.note"/>
      <ref name="element.manfmt"/>
      <ref name="element.warning"/>
      <ref name="element.design"/>
    </choice>
  </define>
  <define name="display">
    <choice>
      <ref name="base.display"/>
      <ref name="local.display"/>
    </choice>
  </define>
<!--     
            Models
-->
<!-- Phrase -->
<!-- Sequence of display components -->
  <define name="m.pseq">
    <choice>
      <ref name="element.p"/>
      <ref name="display"/>
      <ref name="base.include"/>
      <ref name="local.include"/>
      <ref name="base.float"/>
      <ref name="local.float"/>
    </choice>
  </define>
<!-- Paragraph -->
  <define name="m.par">
    <choice>
      <text/>
      <ref name="inline"/>
      <ref name="display"/>
      <ref name="base.float"/>
      <ref name="local.float"/>
      <ref name="base.include"/>
      <ref name="local.include"/>
    </choice>
  </define>
<!-- end of ITSIG exchange Entity Module -->
</grammar>
