<?xml version="1.0" encoding="UTF-8"?>
<grammar datatypeLibrary="http://www.w3.org/2001/XMLSchema-datatypes" xmlns="http://relaxng.org/ns/structure/1.0" xmlns:a="http://relaxng.org/ns/compatibility/annotations/1.0">
<!-- ITSIG exchange Displayed Components Module -->
<!-- file: stdex-disp.mod -->
<!-- ITSIG exchange Displayed Components Module

     (c) International Organization for Standardization 1991 Permission
         to copy in any form is granted for use with comforming WebSGML 
         systems and appilications as defined in ISO 8879:1986(WWW),
         provided this notice is included in all copies.
-->
<!--
          Displayed Elements Types 
-->
<!--      ELEMENTS    CONTENT                 -->
  <define name="element.p">
    <element name="p">
      <ref name="attlist.p"/>
      <zeroOrMore>
        <ref name="m.par"/>
      </zeroOrMore>
    </element>
  </define>
  <define name="attlist.p" combine="interleave">
    <optional>
      <attribute name="id">
        <ref name="ID"/>
      </attribute>
    </optional>
  </define>
<!-- ***** ELEMENT xmp         (%m.par;|p)+    -(%base.xmp;) -->
  <define name="element.xmp">
    <element name="xmp">
      <ref name="attlist.xmp"/>
      <zeroOrMore>
        <choice>
          <ref name="m.par"/>
          <ref name="element.p"/>
        </choice>
      </zeroOrMore>
    </element>
  </define>
  <define name="attlist.xmp" combine="interleave">
    <optional>
      <attribute name="id">
        <ref name="ID"/>
      </attribute>
    </optional>
    <optional>
      <attribute name="gtext"/>
    </optional>
    <optional>
      <attribute name="number" a:defaultValue="number">
        <choice>
          <value>number</value>
          <value>nonum</value>
        </choice>
      </attribute>
    </optional>
  </define>
<!-- ***** ELEMENT note        (%m.par;|p)+     -(%informative;|%include;|%float;|warning|design) -->
  <define name="element.note">
    <element name="note">
      <ref name="attlist.note"/>
      <zeroOrMore>
        <choice>
          <ref name="m.par"/>
          <ref name="element.p"/>
        </choice>
      </zeroOrMore>
    </element>
  </define>
  <define name="attlist.note" combine="interleave">
    <optional>
      <attribute name="id">
        <ref name="ID"/>
      </attribute>
    </optional>
    <optional>
      <attribute name="gtext"/>
    </optional>
    <optional>
      <attribute name="number" a:defaultValue="number">
        <choice>
          <value>number</value>
          <value>nonum</value>
        </choice>
      </attribute>
    </optional>
    <ref name="std.inf"/>
  </define>
<!-- ***** ELEMENT warning     (%m.par|p)+      -(%base.note;|%base.xmp;|warning|%float;) -->
  <define name="element.warning">
    <element name="warning">
      <ref name="attlist.warning"/>
      <zeroOrMore>
        <choice>
          <ref name="m.par"/>
          <ref name="element.p"/>
        </choice>
      </zeroOrMore>
    </element>
  </define>
  <define name="attlist.warning" combine="interleave">
    <optional>
      <attribute name="id">
        <ref name="ID"/>
      </attribute>
    </optional>
    <optional>
      <attribute name="format" a:defaultValue="warning">
        <choice>
          <value>genwarn</value>
          <value>warning</value>
          <value>caution</value>
          <value>remark</value>
        </choice>
      </attribute>
    </optional>
    <optional>
      <attribute name="gtext"/>
    </optional>
  </define>
<!-- manual formatting -->
  <define name="element.manfmt">
    <element name="manfmt">
      <ref name="attlist.manfmt"/>
      <zeroOrMore>
        <choice>
          <text/>
          <ref name="element.hp"/>
          <ref name="element.subscript"/>
          <ref name="element.superscript"/>
        </choice>
      </zeroOrMore>
    </element>
  </define>
  <define name="attlist.manfmt" combine="interleave">
    <optional>
      <attribute name="id">
        <ref name="ID"/>
      </attribute>
    </optional>
  </define>
<!--      ELEMENTS    CONTENT                 -->
  <define name="element.ol">
    <element name="ol">
      <ref name="attlist.ol"/>
      <ref name="element.li"/>
      <zeroOrMore>
        <zeroOrMore>
          <ref name="element.lp"/>
        </zeroOrMore>
        <ref name="element.li"/>
      </zeroOrMore>
    </element>
  </define>
  <define name="attlist.ol" combine="interleave">
    <optional>
      <attribute name="id">
        <ref name="ID"/>
      </attribute>
    </optional>
    <optional>
      <attribute name="format" a:defaultValue="auto">
        <choice>
          <value>alpha</value>
          <value>arabic</value>
          <value>roman</value>
          <value>auto</value>
          <value>arabicn</value>
        </choice>
      </attribute>
    </optional>
  </define>
<!-- *** ELEMENT li          (%m.par;|p)+     -->
  <define name="element.li">
    <element name="li">
      <ref name="attlist.li"/>
      <zeroOrMore>
        <choice>
          <ref name="m.par"/>
          <ref name="element.p"/>
        </choice>
      </zeroOrMore>
    </element>
  </define>
  <define name="attlist.li" combine="interleave">
    <optional>
      <attribute name="id">
        <ref name="ID"/>
      </attribute>
    </optional>
    <optional>
      <attribute name="gtext"/>
    </optional>
  </define>
<!-- *** ELEMENT lp          (%m.par;|p)+     -->
  <define name="element.lp">
    <element name="lp">
      <ref name="attlist.lp"/>
      <zeroOrMore>
        <choice>
          <ref name="m.par"/>
          <ref name="element.p"/>
        </choice>
      </zeroOrMore>
    </element>
  </define>
  <define name="attlist.lp" combine="interleave">
    <optional>
      <attribute name="id">
        <ref name="ID"/>
      </attribute>
    </optional>
  </define>
  <define name="element.ul">
    <element name="ul">
      <ref name="attlist.ul"/>
      <ref name="element.li"/>
      <zeroOrMore>
        <zeroOrMore>
          <ref name="element.lp"/>
        </zeroOrMore>
        <ref name="element.li"/>
      </zeroOrMore>
    </element>
  </define>
  <define name="attlist.ul" combine="interleave">
    <optional>
      <attribute name="id">
        <ref name="ID"/>
      </attribute>
    </optional>
    <optional>
      <attribute name="format" a:defaultValue="auto">
        <choice>
          <value>bullet</value>
          <value>emdash</value>
          <value>sl</value>
          <value>auto</value>
        </choice>
      </attribute>
    </optional>
  </define>
  <define name="element.dl">
    <element name="dl">
      <ref name="attlist.dl"/>
      <ref name="element.dlentry"/>
      <zeroOrMore>
        <zeroOrMore>
          <ref name="element.lp"/>
        </zeroOrMore>
        <ref name="element.dlentry"/>
      </zeroOrMore>
    </element>
  </define>
  <define name="attlist.dl" combine="interleave">
    <optional>
      <attribute name="id">
        <ref name="ID"/>
      </attribute>
    </optional>
    <optional>
      <attribute name="format" a:defaultValue="auto">
        <choice>
          <value>ol</value>
          <value>ul</value>
          <value>syml</value>
          <value>varl</value>
          <value>auto</value>
        </choice>
      </attribute>
    </optional>
  </define>
  <define name="element.dlentry">
    <element name="dlentry">
      <ref name="attlist.dlentry"/>
      <oneOrMore>
        <ref name="element.dt"/>
      </oneOrMore>
      <ref name="element.dd"/>
    </element>
  </define>
  <define name="attlist.dlentry" combine="interleave">
    <optional>
      <attribute name="id">
        <ref name="ID"/>
      </attribute>
    </optional>
  </define>
<!-- ***** ELEMENT dt          (%m.ph;)*  -(fn|xref|extdoc|term|%include;|%float;) -->
  <define name="element.dt">
    <element name="dt">
      <ref name="attlist.dt"/>
      <zeroOrMore>
        <choice>
          <text/>
          <ref name="inline"/>
          <ref name="base.include"/>
          <ref name="local.include"/>
          <ref name="base.float"/>
          <ref name="local.float"/>
        </choice>
      </zeroOrMore>
    </element>
  </define>
  <define name="attlist.dt" combine="interleave">
    <optional>
      <attribute name="id">
        <ref name="ID"/>
      </attribute>
    </optional>
  </define>
<!-- ELEMENT dd          (%m.par;|p)+    -->
  <define name="element.dd">
    <element name="dd">
      <ref name="attlist.dd"/>
      <zeroOrMore>
        <choice>
          <ref name="m.par"/>
          <ref name="element.p"/>
        </choice>
      </zeroOrMore>
    </element>
  </define>
  <define name="attlist.dd" combine="interleave">
    <empty/>
  </define>
  <define name="element.bl">
    <element name="bl">
      <ref name="attlist.bl"/>
      <oneOrMore>
        <ref name="element.blentry"/>
      </oneOrMore>
    </element>
  </define>
  <define name="attlist.bl" combine="interleave">
    <empty/>
  </define>
  <define name="element.blentry">
    <element name="blentry">
      <ref name="attlist.blentry"/>
      <choice>
        <ref name="element.bibdoc"/>
        <ref name="element.extdoc"/>
      </choice>
      <optional>
        <ref name="element.tail"/>
      </optional>
    </element>
  </define>
  <define name="attlist.blentry" combine="interleave">
    <optional>
      <attribute name="id">
        <ref name="ID"/>
      </attribute>
    </optional>
    <optional>
      <attribute name="gtext"/>
    </optional>
  </define>
  <define name="element.tail">
    <element name="tail">
      <ref name="attlist.tail"/>
      <text/>
    </element>
  </define>
  <define name="attlist.tail" combine="interleave">
    <empty/>
  </define>
  <define name="element.rl">
    <element name="rl">
      <ref name="attlist.rl"/>
      <oneOrMore>
        <ref name="element.rlentry"/>
      </oneOrMore>
    </element>
  </define>
  <define name="attlist.rl" combine="interleave">
    <empty/>
  </define>
  <define name="element.rlentry">
    <element name="rlentry">
      <ref name="attlist.rlentry"/>
      <choice>
        <ref name="element.bibdoc"/>
        <ref name="element.extdoc"/>
      </choice>
      <optional>
        <ref name="element.tail"/>
      </optional>
    </element>
  </define>
  <define name="attlist.rlentry" combine="interleave">
    <optional>
      <attribute name="id">
        <ref name="ID"/>
      </attribute>
    </optional>
    <optional>
      <attribute name="gtext"/>
    </optional>
  </define>
</grammar>
