<!-- ITSIG Math Module -->
<!-- file: stdex-math.mod -->

<!-- ITSIG Math Module

     (c) International Organization for Standardization 1991 Permission
         to copy in any form is granted for use with comforming WebSGML 
         systems and appilications as defined in ISO 8879:1986(WWW),
         provided this notice is included in all copies.
-->

<!-- This is the ISO12083:1994 document type definition for Mathematics    -->

<!-- Copyright: (C) International Organization for Standardization 1994.
Permission to copy in any form is granted for use with conforming SGML
systems and applications as defined in ISO 8879:1986, provided this notice
is included in all copies.                                                 -->

<!-- Math Extension Module -->
<!ENTITY % stdex-math-extension.module "INCLUDE" >
<![%stdex-math-extension.module;[
<!ENTITY % stdex-math-extension.mod
    PUBLIC "-//ISO/CS//DTD m12083 extension//EN" "stdex-math-extension.mod" >
%stdex-math-extension.mod;]]>

<!-- ===================================================================== -->
<!--            PUBLIC DOCUMENT TYPE DEFINITION SUBSET                     -->
<!-- ===================================================================== -->

<!--
This DTD is included by the Book and Article DTDs of ISO12083:1994.
As it is a separate entity it may also be included by other DTDs.

Since there is no consensus on how to describe the semantics of formulas,
it only describes their presentational or visual structure. Since, however,
there is a strong need for such description (especially within the
print-disabled community), it is recommended that the following
declaration be added where there is a requirement for a consistent,
standardized mechanism to carry semantic meanings for the SGML
elements declared throughout this part of this International Standard:

<!ENTITY % SDAMAP       "SDAMAP   NAME    #IMPLIED"           >

and that the attribute represented by %SDAMAP; be made available for
all elements which may require a semantic association, or, in the simpler
case, be added to all elements in this DTD.                     -->



<!-- ===================================================================== -->
<!--  Parameter entities describing the possible contents of formulas.     -->
<!-- ===================================================================== -->

<!-- character transformations -->
<!ENTITY % p.trans "bold|italic|sansser|typewrit|smallcap|roman" >
<!-- mathematical formula elements -->
<!ENTITY % m.math "#PCDATA|
   fraction|subform|sup|inf|top|bottom|middle|fence|mark|
   post|box|overline|undrline|radical|array|hspace|vspace|break|markref" >

<!-- ===================================================================== -->
<!-- Accessible Document and other Parameter Entities        
     If this DTD is not imbedded by a ISO12083:1994 Book or Article,
     the comment delimiters should be removed.                             -->
<!-- ===================================================================== -->

<!--ENTITY % SDAFORM      "SDAFORM   CDATA    #FIXED"                      -->
<!--ENTITY % SDARULE      "SDARULE   CDATA    #FIXED"                      --> 
<!--ENTITY % SDAPREF      "SDAPREF   CDATA    #FIXED"                      -->
<!--ENTITY % SDASUFF      "SDASUFF   CDATA    #FIXED"                      -->
<!--ENTITY % SDASUSP      "SDASUSP   NAME     #FIXED"                      -->



<!-- ===================================================================== -->
<!-- This entity is for an attribute to indicate which alphabet is 
     used in the element (formula, dformula). You may change this to 
     a notation attribute, where the notation could describe a 
     keyboard mapping. Please modify the set as necessary.                 
     If this DTD is not imbedded by a ISO12083:1994 Book or Article,
     the comment delimiters should be removed.                             -->
<!-- ===================================================================== -->

<!ENTITY % a.types '(latin|greek|cyrillic|hebrew|kanji) "latin"'           >


<!-- ===================================================================== -->
<!-- character transformations                                             --> 
<!-- ===================================================================== -->

<!--      ELEMENT              CONTENT            -->
<!-- bold -->
<!ELEMENT bold                 (#PCDATA|%p.trans;)* >
<!-- italic -->
<!ELEMENT italic               (#PCDATA|%p.trans;)* >
<!-- sans serif -->
<!ELEMENT sansser              (#PCDATA|%p.trans;)* >
<!-- typewriter -->
<!ELEMENT typewrit             (#PCDATA|%p.trans;)* >
<!-- small caps -->
<!ELEMENT smallcap             (#PCDATA|%p.trans;)* >
<!-- roman -->
<!ELEMENT roman                (#PCDATA|%p.trans;)* >


<!-- ===================================================================== -->
<!-- Fractions                                                             -->
<!-- ===================================================================== -->

<!--      ELEMENT              CONTENT            -->
<!-- fraction -->
<!ELEMENT fraction             (num, den) >
<!-- numerator -->
<!ELEMENT num                  (%m.math;|%p.trans;)* >
<!-- denominator -->
<!ELEMENT den                  (%m.math;|%p.trans;)* >
<!--      ELEMENT   NAME       VALUE            DEFAULT                    -->
<!ATTLIST fraction  shape      (built|case) #IMPLIED
		    align      (left|center|right)   
						"center"
		    style      (single|double|triple|dash|dot|bold|blank|none)
						"single"                     >



<!-- ===================================================================== -->
<!-- Superiors, inferiors, accents, over and under                         -->
<!-- ===================================================================== -->

<!--      ELEMENT              CONTENT             -->
<!-- superior -->
<!ELEMENT sup                  (%m.math;|%p.trans;)* >
<!-- inferior -->
<!ELEMENT inf                  (%m.math;|%p.trans;)* >
<!--      ELEMENT   NAME       VALUE            DEFAULT                    -->
<!ATTLIST sup       location   (pre|post)       "post"
		    arrange    (compact|stagger)
						"compact"                    >
<!ATTLIST inf       location   (pre|post) "post"
		    arrange    (compact|stagger) "compact"                   >


<!-- ===================================================================== -->
<!-- Embellishments                                                        -->
<!-- ===================================================================== -->

<!--      ELEMENT              CONTENT             -->
<!-- top embellishment -->
<!ELEMENT top                  (%m.math;|%p.trans;)* >
<!-- middle, or "through" -->
<!ELEMENT middle               (%m.math;|%p.trans;)* >
<!-- bottom embellishment -->
<!ELEMENT bottom               (%m.math;|%p.trans;)* >

<!--      ELEMENT   NAME       VALUE            DEFAULT                    -->
<!-- to pass on the height -->
<!ATTLIST top       align      (left|center|right) 
						"center"
		    sizeid     ID               #IMPLIED >
<!-- to pass on the height -->
<!ATTLIST middle    align      (left|center|right) 
						"center"
		    sizeid     ID               #IMPLIED >
<!-- to pass on the height -->
<!ATTLIST bottom    align      (left|center|right) 
						"center"
		    sizeid    ID               #IMPLIED >

<!-- The subform element is defined later                                  -->



<!-- ===================================================================== -->
<!-- Fences, boxes, overlines and underlines                               -->
<!-- ===================================================================== -->

<!--      ELEMENT              CONTENT             -->
<!ELEMENT mark                 EMPTY                 >
<!-- fence -->
<!ELEMENT fence                (%m.math;|%p.trans;)* >
<!-- post -->
<!ELEMENT post                 EMPTY >
<!-- box -->
<!ELEMENT box                  (%m.math;|%p.trans;)* >
<!-- overline -->
<!ELEMENT overline             (%m.math;|%p.trans;)* >
<!-- underline -->
<!ELEMENT undrline             (%m.math;|%p.trans;)* >
<!--      ELEMENT   NAME       VALUE            DEFAULT                    -->
<!ATTLIST mark      id         ID               #REQUIRED                    >
<!-- lpost : left post -->
<!-- rpost : right post -->
<!-- sizeid : to pass on the height -->
<!-- sizeref : to pick up a height -->
<!ATTLIST fence     lpost      CDATA            "|" 
		    rpost      CDATA            "|" 
		    style      (single|double|triple|dash|dot|bold|blank|none) 
						"single"
		    sizeid     ID               #IMPLIED 
		    sizeref    IDREF            #IMPLIED >
<!-- sizeid : to pass on the height -->
<!-- sizeref : to pick up a height -->
<!ATTLIST post      post       CDATA            "|"
		    style      (single|double|triple|dash|dot|bold|blank|none) 
						"single"
		    sizeid     ID               #IMPLIED 
		    sizeref    IDREF            #IMPLIED >
<!ATTLIST box       style      (single|double|triple|dash|dot|bold|blank|none) 
						"single"                     >
<!-- type : embellishment type -->
<!ATTLIST overline  type       CDATA            "-" 
		    style      (single|double|triple|dash|dot|bold|blank|none) 
						"single"
		    start      IDREF            #IMPLIED
		    end        IDREF            #IMPLIED                     >

<!-- embellishment type -->
<!ATTLIST undrline  type       CDATA            "_" 
		    style      (single|double|triple|dash|dot|bold|blank|none) 
						"single"
		    start      IDREF            #IMPLIED
		    end        IDREF            #IMPLIED                     >


<!-- ===================================================================== -->
<!-- Labelled arrows                                                       -->
<!-- ===================================================================== -->

<!--      ELEMENT              CONTENT             -->
<!-- base element  -->
<!ELEMENT subform              (%m.math;|%p.trans;)* >
<!--      ELEMENT   NAME       VALUE            DEFAULT                    -->
<!-- sizeid : to pass on a width, or a height -->
<!-- sizeref : to pick up a width -->
<!ATTLIST subform   sizeid     ID               #IMPLIED
		    sizeref    IDREF            #IMPLIED >


<!-- ===================================================================== -->
<!-- Roots                                                                 -->
<!-- ===================================================================== -->

<!--      ELEMENT              CONTENT             -->
<!-- root or radical -->
<!ELEMENT radical              (radix?, radicand) >
<!-- radix -->
<!ELEMENT radix                (%m.math;|%p.trans;)* >
<!-- radicand -->
<!ELEMENT radicand             (%m.math;|%p.trans;)* >


<!-- ===================================================================== -->
<!-- Arrays                                                                -->
<!-- ===================================================================== -->

<!--      ELEMENT              CONTENT             -->
<!-- array -->
<!ELEMENT array                (arrayrow+|arraycol+) >
<!-- array row -->
<!ELEMENT arrayrow             (arraycel+) >
<!-- array column -->
<!ELEMENT arraycol             (arraycel+) >
<!-- array cell -->
<!ELEMENT arraycel             (%m.math;|%p.trans;)* >

<!--      ELEMENT   NAME       VALUE            DEFAULT                    -->
<!-- rowalign : row alignment -->
<!-- colalign : column alignment -->
<!-- rowsep : row separators -->
<!-- colsep : column separators -->
<!ATTLIST array     rowalign   NMTOKENS         #IMPLIED 
		    colalign   NMTOKENS         #IMPLIED 
		    rowsep     NMTOKENS         #IMPLIED 
		    colsep     NMTOKENS         #IMPLIED >


<!-- ===================================================================== -->
<!-- Spacing                                                               -->
<!-- ===================================================================== -->

<!--      ELEMENT              CONTENT        -->
<!-- horizontal spacing -->
<!ELEMENT hspace               EMPTY            >
<!-- vertical spacing -->
<!ELEMENT vspace               EMPTY            >
<!-- turn line, break -->
<!ELEMENT break                EMPTY            >
<!-- hmark reference -->
<!ELEMENT markref              EMPTY            >

<!--      ELEMENT   NAME       VALUE            DEFAULT                    -->
<!-- units as required -->
<!ATTLIST hspace    space      CDATA            "2 dd" >
<!-- units as required -->
<!ATTLIST vspace    space      CDATA            "2 dd" >
<!-- direct : horizontal or vertical -->
<!ATTLIST markref   refid      IDREF            #REQUIRED
		    direct     (hor|ver)        "hor" >


<!-- ===================================================================== -->
<!-- the formula elements                                                  -->
<!-- ===================================================================== -->
<!ENTITY % std.mart "" >

<!--      ELEMENT              CONTENT                          -->
<!-- in-line formula -->
<!ELEMENT formula              (%m.math;|%p.trans;|%std.mart;)*   >
<!-- display formula -->
<!ELEMENT dformula             (%m.math;|%p.trans;|%std.mart;)*   >

<!--      ELEMENT   NAME       VALUE            DEFAULT                    -->
<!ATTLIST formula   id         ID               #IMPLIED
                    mathnota (TR9573|I12083|LATEX) "I12083"             
                    mode     (DISPLAY|INLINE) #FIXED "INLINE"
		    alphabet   %a.types; >

<!ATTLIST dformula  id         ID               #IMPLIED
                    num      (num|nonum) "nonum"                          
		    align      (left|center|right) "center"
                    gtext      CDATA           #IMPLIED
                    mathnota (TR9573|I12083|LATEX) "I12083"
                    mode     (DISPLAY|INLINE) #FIXED "DISPLAY"
		    alphabet   %a.types; >
