<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/TR/WD-xsl">

<xsl:template match="/">
<html>
	<head>
		<title>ISO/IEC IT --- Simple Test again ---</title>
	</head>
	<style>
		h1		{ font-size: 20pt ;
				color : white ;
				background-color: blue ;}
		h2		{ font-soze: 24pt ;
				color : white ;
				background-color: green ;}
		h3		{ font-size: 12pt ;
				color : black ;
				background-color: white ;}
		h4		{ font-size: 10pt ;
				color : black ;
				background-color: white ;}
		h5		{ font-size: 10pt ;
				color : black ;
				background-color: white ;}
		h6		{ font-size: 10pt ;
				color : black ;
				background-color: white ;}
		strong.blue	{ color: blue ;
				font-weight: bold ;}
		dt		{ font-weight: bold ;}
		ol		{ list-style: lower-alpha outside ;}
		ul.disc	{ list-style-type: disc ;}
		ul.circle	{ list-style-type: circle ;}
		ul.square	{ list-style-type: square ;}
		ol.low-roman	{ list-style-type: lower-roman ;}
		ol.up-roman	{ list-style-type: upper-roman ;}
		ol.low-alpha	{ list-style-type: lower-alpha ;}
		ol.up-alpha	{ list-style-type: upper-alpha ;}
		ol.decimal	{ list-style-type: decimal ;}
		ul.image	{ list-style-image: url(bullet.jpg) ;}
		ul.none	{ list-style-type: none ;}
		a:link		{ color: blue ;}
		a:visit		{ text-decoration: line-through ;}
		a:active	{ color: red ;}
		a:hover		{ color: white ;}
		p		{ margin-top : 0.5em ;
				margin-bottom : 1.5em ;}
		item		{ color: blue ;
				font-weight: bold ;}
		fn		{ color: blue ;
				font-weight: bold ;}
		
    	</style>
<body>
    <xsl:apply-templates select="html/standard/foreword"/>
    <xsl:apply-templates select="html/standard/body/scope"/>
    <xsl:apply-templates select="html/standard/body/refs"/>
    <xsl:apply-templates select="html/standard/body/defs"/>
    <xsl:apply-templates select="html/standard/body/h1[0]"/>
    <xsl:apply-templates select="html/standard/body/h1[1]"/>
    <xsl:apply-templates select="html/standard/body/h1[2]"/>
</body>
</html>
</xsl:template>

<xsl:template match="html/standard/foreword">
    <H1>0 <xsl:value-of select="./ht"/></H1>
    <P><xsl:value-of select="./p"/></P>
</xsl:template>

<xsl:template match="html/standard/body/scope">
    <H1>1 <xsl:value-of select="./ht"/></H1>
    <p><b><xsl:value-of select="./p/item"/></b>
    (<xsl:value-of select="./p/fn"/>)</p>
    <xsl:for-each select="./note">
    <P>note: <xsl:value-of select="."/></P>
    </xsl:for-each>
</xsl:template>

<xsl:template match="html/standard/body/refs">
    <H1>2 <xsl:value-of select="./ht"/></H1>
    <P><xsl:value-of select="./p"/></P>
</xsl:template>

<xsl:template match="html/standard/body/defs">
    <H1>3 <xsl:value-of select="./ht"/></H1>
    <P><xsl:value-of select="./p"/></P>
</xsl:template>

<xsl:template match="html/standard/body/h1[0]">
    <H1>4 <xsl:value-of select="./ht"/></H1>
    <H2>4.1 <xsl:value-of select="./h2[0]/ht"/></H2>
    <P><xsl:value-of select="./h2[0]/p"/></P>
    <P>note: <xsl:value-of select="./h2[0]/note"/></P>
    <H2>4.2 <xsl:value-of select="./h2[1]/ht"/></H2>
    <H3>4.2.1 <xsl:value-of select="./h2[1]/h3[0]/ht"/></H3>
    <P><xsl:value-of select="./h2[1]/h3[0]/p"/></P>
    <P>note: <xsl:value-of select="./h2[1]/h3[0]/note"/></P>
    <H3>4.2.2 <xsl:value-of select="./h2[1]/h3[1]/ht"/></H3>
    <H4>4.2.2.1 <xsl:value-of select="./h2[1]/h3[1]/h4[0]/ht"/></H4>
    <P><xsl:value-of select="./h2[1]/h3[1]/h4[0]/p"/></P>
    <P>note: <xsl:value-of select="./h2[1]/h3[1]/h4[0]/note"/></P>
    <H4>4.2.2.2 <xsl:value-of select="./h2[1]/h3[1]/h4[1]/ht"/></H4>
    <H5>4.2.2.2.1 <xsl:value-of select="./h2[1]/h3[1]/h4[1]/h5[0]/ht"/></H5>
    <P><xsl:value-of select="./h2[1]/h3[1]/h4[1]/h5[0]/p"/></P>
    <P>note: <xsl:value-of select="./h2[1]/h3[1]/h4[1]/h5[0]/note"/></P>
    <H5>4.2.2.2.2 <xsl:value-of select="./h2[1]/h3[1]/h4[1]/h5[1]/ht"/></H5>
    <H6>4.2.2.2.2.1 <xsl:value-of select="./h2[1]/h3[1]/h4[1]/h5[1]/h6[0]/ht"/></H6>
    <P><xsl:value-of select="./h2[1]/h3[1]/h4[1]/h5[1]/h6[0]/p"/></P>
    <P>note: <xsl:value-of select="./h2[1]/h3[1]/h4[1]/h5[1]/h6[0]/note"/></P>
    <H6>4.2.2.2.2.2 <xsl:value-of select="./h2[1]/h3[1]/h4[1]/h5[1]/h6[1]/ht"/></H6>
    <P><xsl:value-of select="./h2[1]/h3[1]/h4[1]/h5[1]/h6[1]/p"/></P>
    <P>note: <xsl:value-of select="./h2[1]/h3[1]/h4[1]/h5[1]/h6[1]/note"/></P>
</xsl:template>

<xsl:template match="html/standard/body/h1[1]">
    <H1>5 <xsl:value-of select="./ht"/></H1>
    <xsl:for-each select="./p2[0]/p">
    	<P><xsl:value-of select="."/></P>
    </xsl:for-each>
    <P>note: <xsl:value-of select="./h2[0]/note"/></P>
    <p><xsl:value-of select="./p2[1]/p"/></p>
    <xsl:for-each select="./p2[1]/p3[0]/p">
    	<P><xsl:value-of select="."/></P>
    </xsl:for-each>
    <P>note: <xsl:value-of select="./p2[1]/p3[0]/note"/></P>
    <p><xsl:value-of select="./p2[1]/p3[1]/p"/></p>
    <xsl:for-each select="./p2[1]/p3[1]/p4[0]/p">
    	<P><xsl:value-of select="."/></P>
    </xsl:for-each>
    <P>note: <xsl:value-of select="./p2[1]/p3[1]/p4[0]/note"/></P>
    <p><xsl:value-of select="./p2[1]/p3[1]/p4[1]/p"/></p>
    <xsl:for-each select="./p2[1]/p3[1]/p4[1]/p5[0]/p">
    	<P><xsl:value-of select="."/></P>
    </xsl:for-each>
    <P>note: <xsl:value-of select="./p2[1]/p3[1]/p4[1]/p5[0]/note"/></P>
    <p><xsl:value-of select="./p2[1]/p3[1]/p4[1]/p5[1]/p"/></p>
    <xsl:for-each select="./p2[1]/p3[1]/p4[1]/p5[1]/p6[0]/p">
    	<P><xsl:value-of select="."/></P>
    </xsl:for-each>
    <P>note: <xsl:value-of select="./p2[1]/p3[1]/p4[1]/p5[1]/p6[0]/note"/></P>
    <P><xsl:value-of select="./p2[1]/p3[1]/p4[1]/p5[1]/p6[1]/p"/></P>
</xsl:template>

<xsl:template match="html/standard/body/h1[2]">
    <H1>6 <xsl:value-of select="./ht"/></H1>
    <P><xsl:value-of select="./p[0]"/></P>
    <UL class="disc"><xsl:for-each select="./ul[0]/li">
    	<LI><xsl:value-of select="./i"/>
    	<P><xsl:value-of select="./note"/></P>
    	</LI>
    </xsl:for-each></UL>
    <P><xsl:value-of select="./p[1]"/></P>
    <UL class="square"><xsl:for-each select="./ul[1]/li">
    	<LI><xsl:value-of select="."/></LI>
    </xsl:for-each></UL>
    <P><xsl:value-of select="./p[2]"/></P>
    <UL class="none"><xsl:for-each select="./ul[2]/li">
    	<LI>- <xsl:value-of select="."/></LI>
    </xsl:for-each></UL>
    <P><xsl:value-of select="./p[3]"/></P>
    <UL class="circle"><xsl:for-each select="./ul[3]/li">
    	<LI><xsl:value-of select="."/></LI>
    </xsl:for-each></UL>
    <P><xsl:value-of select="./p[4]"/></P>
    <UL>
    	<LI><xsl:value-of select="./ul[4]/li[0]"/></LI>
    	<LI>
    		<xsl:value-of select="./ul[4]/li[1]/i"/>
    		 <UL><xsl:for-each select="./ul[4]/li[1]/ul/li">
    			<LI><xsl:value-of select="."/></LI>
    		</xsl:for-each></UL>
    	</LI>
    	<LI><xsl:value-of select="./ul[4]/li[2]"/></LI>
    </UL>
    <P><xsl:value-of select="./p[5]"/></P>
    	 <OL><xsl:for-each select="./ol[0]/li">
    		<LI><xsl:value-of select="."/></LI>
    	</xsl:for-each></OL>
    <P><xsl:value-of select="./p[6]"/></P>
    	 <OL class="up-alpha"><xsl:for-each select="./ol[1]/li">
    		<LI><xsl:value-of select="."/></LI>
    	</xsl:for-each></OL>
    <P><xsl:value-of select="./p[7]"/></P>
    	 <OL class="decimal"><xsl:for-each select="./ol[2]/li">
    		<LI><xsl:value-of select="."/></LI>
    	</xsl:for-each></OL>
    <P><xsl:value-of select="./p[8]"/></P>
    	 <OL class="low-roman"><xsl:for-each select="./ol[3]/li">
    		<LI><xsl:value-of select="."/></LI>
    	</xsl:for-each></OL>
    <P><xsl:value-of select="./p[9]"/></P>
    	 <OL class="up-roman"><xsl:for-each select="./ol[4]/li">
    		<LI><xsl:value-of select="."/></LI>
    	</xsl:for-each></OL>
    <P><xsl:value-of select="./p[10]"/></P>

</xsl:template>

</xsl:stylesheet>
