<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/TR/WD-xsl">

<xsl:template match="/">
<html>
	<head>
		<title>ISO/IEC IT --- Simple Test ---</title>
	</head>
	<style>
		h1		{ font-size: 20pt ;
				color : white ;
				background-color: blue ;}
		h2		{ font-soze: 14pt ;
				background-color: yellow ;}
		h3		{ font-size: 12pt ;
				color : black ;
				background-color: white ;}
		strong.blue	{ color: blue ;
				font-weight: bold ;}
		ul		{ list-style: lower-alpha outside }
		ol		{ list-style: lower-alpha outside }
		a:link		{ color: blue ;}
		a:visit		{ text-decoration: line-through ;}
		a:active	{ color: red ;}
		a:hover		{ color: white ;}
		p		{ margin-top : 0.5em ;
				margin-bottom : 1.5em ;}
    	</style>
<body>
    <H1><xsl:value-of select="html/document/body/title"/></H1>
    <xsl:apply-templates select="html/document/body/scope"/>
	<H2>1 Scope</H2>
    <xsl:apply-templates select="html/document/body/scope/p"/>
    <xsl:apply-templates select="html/document/body/conf"/>
	<H2>2 Conformance</H2>
    <xsl:apply-templates select="html/document/body/conf/p"/>
    <xsl:apply-templates select="html/document/body/refs"/>
	<H2>3 Normative Refernce</H2>
    <xsl:apply-templates select="html/document/body/refs/p"/>
    <xsl:apply-templates select="html/document/body/defs"/>
	<H2>4 Definitions</H2>
    <xsl:apply-templates select="html/document/body/defs/p"/>
    <xsl:apply-templates select="html/document/body/sec[0]"/>
	<H2>5 Notation and Conventions</H2>
    <xsl:apply-templates select="html/document/body/sec[0]/subsec[0]"/>
	<H3>5.1 Syntax Production</H3>
    <xsl:apply-templates select="html/document/body/sec[0]/subsec[0]/p"/>
    <xsl:apply-templates select="html/document/body/sec[0]/subsec[1]"/>
	<H3>5.2 Procedure Prototype</H3>
    <xsl:apply-templates select="html/document/body/sec[0]/subsec[1]/p"/>
    <xsl:apply-templates select="html/document/body/sec[1]"/>
	<H2>6 DSSSL Overview</H2>
    <xsl:apply-templates select="html/document/body/sec[1]/p"/>
    <xsl:apply-templates select="html/document/body/sec[1]/subsec[0]"/>
    <xsl:apply-templates select="html/document/body/sec[1]/subsec[1]"/>
</body>
</html>
</xsl:template>

<xsl:template match="html/document/body/scope/p">
	<xsl:value-of select="./p1[0]"/>
	<ol type='a'>
		<li><p><xsl:value-of select="//scope/p/ol/li[0]"/></p></li>
		<li><p><xsl:value-of select="//scope/p/ol/li[1]"/></p></li>
	</ol>
	<p><xsl:value-of select="./p1[1]"/></p>
	<p><xsl:value-of select="./p1[2]"/></p>
	<p><xsl:value-of select="./p1[3]"/></p>
	<p><xsl:value-of select="./p1[4]"/></p>
	<ol type='a'>
		<li><p><xsl:value-of select="//scope/p/ol[1]/li[0]"/></p></li>
		<p>NOTE 1 -<small><xsl:value-of select="//scope/p/ol/note[0]"/>
		</small></p>
		<li><p><xsl:value-of select="//scope/p/ol[1]/li[1]"/></p></li>
		<li><p><xsl:value-of select="//scope/p/ol[1]/li[2]"/></p></li>
		<li><p><xsl:value-of select="//scope/p/ol[1]/li[3]"/></p></li>
		<li><p><xsl:value-of select="//scope/p/ol[1]/li[4]"/></p></li>
		<li><p><xsl:value-of select="//scope/p/ol[1]/li[5]"/></p></li>
	</ol>
	<p><xsl:value-of select="./p1[5]"/></p>
</xsl:template>

<xsl:template match="html/document/body/conf/p">
	<xsl:for-each select="//body/conf/p/p1">
		<p><xsl:value-of select="."/></p>
	</xsl:for-each>
</xsl:template>

<xsl:template match="html/document/body/refs/p">
	<p><xsl:value-of select="//body/refs/p/p1[0]"/></p>
	<xsl:for-each select="//body/refs/p/p1">
		<p><xsl:value-of select="./ni"/>
		<i><xsl:value-of select="i"/></i>
		</p>
	</xsl:for-each>
</xsl:template>

<xsl:template match="html/document/body/defs/p">
	<p><xsl:value-of select="//body/defs/p/p1"/></p>
	<xsl:for-each select="//body/defs/p/dp">
		<p><b><xsl:value-of select="./tm"/></b>
		<br><xsl:value-of select="df"/></br>
		</p>
	</xsl:for-each>	
</xsl:template>

<xsl:template match="html/document/body/sec[0]/subsec[0]/p">
        <xsl:if test="@s[. ='n']">
		<p><xsl:value-of select="."/></p>
	</xsl:if>
	<xsl:if test="@s[. ='i']">
		<p><i><xsl:value-of select="."/></i></p>
        </xsl:if>
        <xsl:if test="@s[. ='n2']">
		<xsl:value-of select="."/>
	</xsl:if>
	<xsl:if test="@s[. ='i2']">
		<i><xsl:value-of select="."/></i>
        </xsl:if>
        <xsl:if test="@s[. ='n3']">
		<xsl:value-of select="."/><br></br>
	</xsl:if>
</xsl:template>

<xsl:template match="html/document/body/sec[0]/subsec[1]/p">
        <xsl:if test="@s[. ='n']">
		<p><xsl:value-of select="."/></p>
	</xsl:if>
	<xsl:if test="@s[. ='j']">
		- <i><xsl:value-of select="."/></i>
        </xsl:if>
	<xsl:if test="@s[. ='i']">
		<p><i><xsl:value-of select="."/></i></p>
        </xsl:if>
        <xsl:if test="@s[. ='n2']">
		<xsl:value-of select="."/>
	</xsl:if>
	<xsl:if test="@s[. ='i2']">
		<i><xsl:value-of select="."/></i>
        </xsl:if>
        <xsl:if test="@s[. ='n3']">
		<xsl:value-of select="."/><br></br>
	</xsl:if>
</xsl:template>

<xsl:template match="html/document/body/sec[1]/p">
	<p><xsl:value-of select="."/></p>
</xsl:template>

<xsl:template match="html/document/body/sec[1]/subsec[0]">
	<H3>6.1 Area of Standardization</H3>
	<p><xsl:value-of select="./p[0]"/></p>
	<ol type="a">
		<li><xsl:value-of select="./ol/li[0]"/></li>
		<p><xsl:value-of select="./ol/p[0]"/></p>
		<li><xsl:value-of select="./ol/li[1]"/></li>
		<p><xsl:value-of select="./ol/p[1]"/></p>
		<p>NOTE 2 - <small>
			<xsl:value-of select="./ol/note"/>
		</small></p>
		<li><xsl:value-of select="./ol/li[2]"/></li>
		<p><xsl:value-of select="./ol/p[2]"/></p>
		<li><xsl:value-of select="./ol/li[3]"/></li>
		<p><xsl:value-of select="./ol/p[3]"/></p>
	</ol>
</xsl:template>

<xsl:template match="html/document/body/sec[1]/subsec[1]">
	<H3>6.2 Conceptual Model</H3>
	<p><xsl:value-of select="./p[0]"/></p>
	<p><xsl:value-of select="./p[1]"/></p>
        <img src="fig/fig1.jpg" width="369" height="272" />
</xsl:template>

</xsl:stylesheet>
